<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Tokenex {
    
    public $api_key, $tokenex_id, $api_tokenization_url, $api_payment_url, $api_iframe_url, $api_transparent_url, 
            $payu_url, $x_payments_os_env, $api_version; // thses for payu hub

    public function __construct()
    {
        $this->ci =& get_instance();
                
        $this->api_key = isset($_SERVER["TOKENEX_API_KEY"]) ? $_SERVER["TOKENEX_API_KEY"] : "orC9oWlFqEU07Hbrt2es";
        $this->tokenex_id = isset($_SERVER["TOKENEX_ID"]) ? $_SERVER["TOKENEX_ID"] : "6611719727754570";
        
        $api_prefix = ($this->ci->config->item('app_environment') == "development") ? "test-" : "";
        $this->api_tokenization_url = "https://".$api_prefix."api.tokenex.com/TokenServices.svc/REST/";
        $this->api_payment_url = "https://".$api_prefix."api.tokenex.com/PaymentServices.svc/REST/";
        $this->api_iframe_url = "https://".$api_prefix."htp.tokenex.com/api/v2/";
        $this->api_transparent_url = "https://".$api_prefix."api.tokenex.com/TransparentGatewayAPI/";
    }
    
    public function tokenize($data){
        $data['TokenScheme']  = TOKEN_SCHEME_TOKEN;
        $response_xml = $this->call_api($this->api_tokenization_url, 'Tokenize', $data);
        $response_obj = $this->xml_to_object($response_xml);
        $response = array();
        if($response_obj->Success == 'true')
        {
            $response['token'] = (string)$response_obj->Token;
        }
        elseif($response_obj->Success == 'false')
        {
            $response['error'] = (string)$response_obj->Error;
        }
        return $response;
    }
    
    public function detokenize($data){
        $response_xml = $this->call_api($this->api_tokenization_url, 'Detokenize', $data);
        $response_obj = $this->xml_to_object($response_xml);
        $response['response_xml'] = $response_xml;
        if($response_obj->Success == 'true')
        {
            $response['data'] = (string)$response_obj->Value;
        }
        elseif($response_obj->Success == 'false')
        {
            $response['error'] = (string)$response_obj->Error;
        }
        return $response;
    }
    
    public function validate_token($data){
        $response_xml = $this->call_api($this->api_tokenization_url, 'ValidateToken', $data);
        $response_obj = $this->xml_to_object($response_xml);
        return $response_obj;
    }
    
    public function xml_to_object($response_xml){
       return simplexml_load_string($response_xml);
    }
    
    public function call_api($api_url, $method_name, $data = array(), $header = null, $is_tranparent_payment = null, $request_method = null){
        $data['APIKey'] = $this->api_key;
        $data['TokenExID'] = $this->tokenex_id;
        
        $url = $api_url.$method_name;
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

        if($request_method == 'put'){
            curl_setopt($ch, CURLOPT_PUT, 1);
        } else {
            curl_setopt($ch, CURLOPT_POST, 1);
        }

        if($is_tranparent_payment)
        {
            unset($data['APIKey']);
            unset($data['TokenExID']);
            $data = json_encode($data);
            curl_setopt($ch, CURLOPT_ENCODING, '');
            curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        }
        else
        {
            $data = json_encode($data);
            if(!empty($data)){
                $content_length = strlen($data);
            }
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json', "Content-Length:$content_length"));
        }
        if($request_method == 'put'){
            // PUT don't need CURLOPT_POSTFIELDS
        } else {
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        }

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_MAXCONNECTS, 1);
                   
        $output = curl_exec($ch);
        
        if(curl_error($ch))
            echo curl_error($ch);
         
        curl_close($ch);
        return $output;
    }
    
    function delete_token($token)
    {
        $data["Token"] = $token;
        $response_xml = $this->call_api($this->api_tokenization_url, 'DeleteToken', $data);
        $response_obj = $this->xml_to_object($response_xml);
        if($response_obj->Success == 'true')
        {
            $response['success'] = true;
        }
        elseif($response_obj->Success == 'false')
        {
            $response['error'] = (string)$response_obj->Error;
        }
        return $response;
    }

    function _get_credit_card_type($cardNumber) {
        // Remove non-digits from the number
        $cardNumber = preg_replace('/\D/', '', $cardNumber);
     
        // Validate the length
        $len = strlen($cardNumber);
        if ($len < 15 || $len > 16) {
            throw new Exception("Invalid credit card number. Length does not match");
        } else {
            switch($cardNumber) {
                case(preg_match ('/^4/', $cardNumber) >= 1):
                    return 'Visa';
                case(preg_match ('/^5[1-5]/', $cardNumber) >= 1):
                    return 'Master';
                case(preg_match ('/^3[47]/', $cardNumber) >= 1):
                    return 'Amex';
                case(preg_match ('/^3(?:0[0-5]|[68])/', $cardNumber) >= 1):
                    return 'Diners';
                case(preg_match ('/^6(?:011|5)/', $cardNumber) >= 1):
                    return 'Discover';
                case(preg_match ('/^(?:2131|1800|35\d{3})/', $cardNumber) >= 1):
                    return 'JCB';
                default:
                    throw new Exception("Could not determine the credit card type.");
                    break;
            }
        }
    }
}
